import re

class PrimsUtils:
    @staticmethod
    def get_mesh_path(prim_path: str) -> str | None:
        """
        Get the root mesh path from a refrence prim path using regular expressions.

        Examples:
            /RootNode/meshes/mesh_HASH/mesh -> /RootNode/meshes/mesh_HASH

        Args:
            prim_path: The prim path to get the mesh path from

        Returns:
            The mesh path if the prim path matches the pattern, otherwise None
        """
        mesh_pattern = r"^(.*mesh_[A-Z0-9]{16}(?:_[0-9])*)\/.*$"
        pattern_match = re.match(mesh_pattern, prim_path)
        if pattern_match:
            return pattern_match.group(1)
        return None