from .operators import register as register_operators
from .operators import unregister as unregister_operators
from .panels import register as register_panels
from .panels import unregister as unregister_panels
from .properties import register as register_properties
from .properties import unregister as unregister_properties

def register():
    register_operators()
    register_panels()
    register_properties()

def unregister():
    unregister_properties()
    unregister_panels()
    unregister_operators()

if __name__ == "__main__":
    register()